/*
Mappings of response actions to stimuli within specific contexts.
For each context  array of possible actions.
inputId  InputActions ID
outputId  OutputActions ID
*/
window.ActionsFromContext = [
  // id=0: Ventilation  responds to vital 0 (Suffocation)
  [
    { inputId: 0, outputId: 1 }, // Spray water > Clear spiracles
    { inputId: 1, outputId: 1 }, // Dust coating > Clear spiracles
    { inputId: 20, outputId: 24 } // Frighten > Interrupt ventilation
  ],
  // id=1: Drinking  responds to vital 1 (Thirst)
  [
    { inputId: 6, outputId: 3 }, // Provide water > Drinks
    { inputId: 5, outputId: 6 }, // Water glint > Runs to water
    { inputId: 4, outputId: 4 }, // Dehydrating wind > Seeks shelter
    { inputId: 20, outputId: 23 }, // Frighten > Interrupt drinking
    { inputId: 15, outputId: 23 }, // Bright flash > Interrupt
    { inputId: 16, outputId: 23 }, // Loud sound > Interrupt
    { inputId: 19, outputId: 23 }, // Startle > Interrupt
    { inputId: 21, outputId: 23 }  // Injure > Interrupt
  ],
  // id=2: Cooling  vital 2 (Heat)
  [
    { inputId: 12, outputId: 11 }, // Heat up > Attempts to cool
    { inputId: 3,  outputId: 11 }, // Dehydrating wind > Cooling
    { inputId: 0,  outputId: 26 }  // Spray water > Evaporative cooling
  ],
  // id=3: Warming  vital 3 (Cold)
  [
    { inputId: 13, outputId: 12 }, // Frostbite > Torpor
    { inputId: 14, outputId: 13 }  // Cool down > Shivers
  ],
  // id=4: Feeding  vital 4 (Hunger)
  [
    { inputId: 7, outputId: 10 }, // Exertion > Avoids effort
    { inputId: 8, outputId: 8 },  // Exhaust > Exhausted state
    { inputId: 9, outputId: 9 },  // Prey visible > Runs to prey
    { inputId:10, outputId: 7 },  // Provide food > Eats
    { inputId:12, outputId: 9 },  // Heat > Seeks prey
    { inputId:20, outputId:22 },  // Frighten > Interrupt feeding
    { inputId:15, outputId:22 },  // Bright flash > Interrupt
    { inputId:16, outputId:22 },  // Loud sound > Interrupt
    { inputId:19, outputId:22 },  // Startle > Interrupt
    { inputId:21, outputId:22 }   // Injure > Interrupt
  ],
  // id=5: Freezing  vital 5 (Stress)
  [
    { inputId:15, outputId:14 }, // Bright flash > Alert freezing
    { inputId:16, outputId:14 }, // Loud sound > Alert freezing
    { inputId: 7, outputId:14 }, // Exertion > Freezing
    { inputId:26, outputId:21 }  // Pleasant breeze > Calms down
  ],
  // id=6: Mating  vital 6 (Mating urge)
  [
    { inputId:18, outputId:16 }, // Mating partner > Reproductive behavior
    { inputId:20, outputId:27 }, // Frighten > Interrupt mating
    { inputId:15, outputId:27 }, // Bright flash > Interrupt
    { inputId:16, outputId:27 }, // Loud sound > Interrupt
    { inputId:19, outputId:27 }, // Startle > Interrupt
    { inputId:21, outputId:27 }  // Injure > Interrupt
  ],
  // id=7: Avoidance  vital 7 (Self-preservation)
  [
    { inputId:20, outputId:17 } // Frighten > Passive defense
  ],
  // id=8: Healing  vital 8 (Wounds)
  [
    { inputId:22, outputId:19 } // Disease > Attempts healing
  ],
  // id=9: Rest  no active responses
  [
    { inputId:20, outputId:20 }, // Frighten > Startled
    { inputId:26, outputId:21 }, // Pleasant breeze > Calms down
    { inputId:20, outputId:28 }, // Frighten > Interrupt rest
    { inputId:15, outputId:28 }, // Bright flash > Interrupt
    { inputId:16, outputId:28 }, // Loud sound > Interrupt
    { inputId:19, outputId:28 }, // Startle > Interrupt
    { inputId:21, outputId:28 }  // Injure > Interrupt
  ],
  // id=10: Sleep  blocks all
  []
];