/* Insect's response actions
vital  which vital is directly affected by shift and losses
Action may occur in any basic context, determined by evolutionarily optimized window.ActionsFromContext
+/-shift  direct effect on vital.value
losses  oxygen and energy cost of action (function losses_per_action)  increase deviation from norm
*/
window.OutputActions = [
  {Id: 0, vital:0, shift: 0, losses:1,
   name: "Panic",
   descr: "Convulsive, disordered movements, flipping, frantic running."},
  // (pressure/humidity sensor)
  {Id: 1, vital:0, shift: -2, losses:0.1,
   name: "Clear spiracle blockage. Accelerated tracheal ventilation",
   descr: "Shakes body, cleans with legs"},
  {Id: 2, vital:0, shift: 0, losses:0.3,
   name: "Runs to find air",
   descr: "Changes direction, bumps into obstacles"},
  //______________________________________
  {Id: 3, vital:1, shift: -10, losses:0.1,
   name: "Drinks water",
   descr: "Quenches thirst"},
  {Id: 4, vital:1, shift: 0, losses:0.3,
   name: "Seeks shelter",
   descr: "Explores enclosed spaces"},
  {Id: 5, vital:1, shift: 0, losses:0.3,
   name: "Searches for water",
   descr: "Changes direction, attempts to detect humidity"},
  {Id: 6, vital:1, shift: 0, losses:0.3,
   name: "Runs toward seen water",
   descr: "Attempts to detect humidity"},
  //______________________________________
  {Id: 7, vital:4, shift: -10, losses:0.1,
   name: "Eats",
   descr: "Consumes food"},
  {Id: 8, vital:4, shift: 0, losses:0.3,
   name: "Exhausted state",
   descr: "Freezes from fatigue"},
  {Id: 9, vital:4, shift: 0, losses:0.3,
   name: "Runs toward prey",
   descr: "Tries to detect scent and movement"},
  {Id:10, vital:4, shift: 0, losses:0.2,
   name: "Avoids effort",
   descr: "Struggles in all directions"},
  //______________________________________
  {Id:11, vital:2, shift: -0.1, losses:0.5,
   name: "Attempts to cool down",
   descr: "Spreads wings, seeks to burrow"},
  //______________________________________
  {Id:12, vital:3, shift: 0, losses:0.01,
   name: "Torpor",
   descr: "Slowed movements"},
  {Id:13, vital:4, shift: -0.1, losses:0.3,
   name: "Shivers, seeks warmth or sunlight",
   descr: "Generates heat. Seeks warm spot"},
  //______________________________________
  {Id:14, vital:5, shift: 0, losses:0.05,
   name: "Alert freezing",
   descr: "All senses heightened, ready to act"},
  //______________________________________
  {Id:15, vital:6, shift: 0, losses:0.05,
   name: "Searches for mating partner",
   descr: "Tries to locate pheromone source"},
  {Id:16, vital:6, shift: -10, losses:0.5,
   name: "Reproductive behavior",
   descr: "Attempts to mate and fulfill reproductive mission"},
  //______________________________________
  {Id:17, vital:7, shift: 0, losses:0.3,
   name: "Passive defense",
   descr: "Tries to hide or jump away"},
  {Id:18, vital:7, shift: 0, losses:0.5,
   name: "Active defense",
   descr: "Raises limbs, sprays repellent"},
  //______________________________________
  {Id:19, vital:8, shift: -0.5, losses:0.05,
   name: "Attempts healing",
   descr: "Minimizes movement. Consumes toxic plants against parasites. Cleans wound with mouthparts"},
  //______________________________________ for Rest context
  {Id:20, vital:7, shift: 10, losses:0.05,
   name: "Startled",
   descr: "Freezes, alert"},
  {Id:21, vital:7, shift: -10, losses:0.01,
   name: "Calms down",
   descr: "Insect breathes easily"},
  {Id:22, vital:4, shift: 0, losses:0.2,
   name: "Interrupts feeding",
   descr: "Abruptly stops eating and freezes due to threat"},
  {Id:23, vital:1, shift: 0, losses:0.2,
   name: "Interrupts water search",
   descr: "Stops drinking and freezes in response to threat"},
  {Id:24, vital:0, shift: 0, losses:0.2,
   name: "Interrupts ventilation",
   descr: "Briefly freezes despite suffocation due to sudden threat"},
  {Id:25, vital:4, shift: 0, losses:0.05,
   name: "Rests",
   descr: "Ceases activity due to fatigue"},
  {Id:26, vital:0, shift: -0.5, losses:0.2,
   name: "Evaporative cooling",
   descr: "Uses water to cool body (in some species)"},
  {Id:27, vital:6, shift: 0, losses:0.2,
   name: "Interrupts mating",
   descr: "Briefly freezes due to sudden threat"},
  {Id:28, vital:5, shift: 10, losses:0.2,
   name: "Interrupts rest",
   descr: "Stress from sudden threat"}
];

////////////////////////////////////////////////////////////////////
/* Called from sep_of_puls() every second
Upon context change or stimulus in current context  bound action is triggered (Beast-style).
Three response cases:
1) Stimulus only changes homeostat state (OutputActions), reaction starts in current context via ActionsFromContext.
2) Stimulus directly triggers response in established context.
3) Watchdog reactions: if context is active but no matching stimulus  fallback reaction based on vital meaning.
Sleep/wake only by button (no circadian simulation needed).
Watchdog awakening in getActiveBasicContexts().
Hardware-level prioritization prevents simultaneous reactions.
Returns actionID if reaction occurred, otherwise -1.
*/
function output_action_and_info()
{ 
//        sep_of_puls()   

//        
		//    :
		if (InputActions[2].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(0); // 
		  // return 0; -      
		}
		//   :
		if (InputActions[4].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(0); // 
		  return 0;
		}
//   :
		if (InputActions[8].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(8); // 
		  return 8;
		}
		//   :
		if (InputActions[11].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(0); // 
		  return 0;
		}
		//   :
		if (InputActions[13].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(12); // 
		  return 12;
		}
//   :
		if (InputActions[17].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(15); //   
		  return 15;
		}
// :
		if (InputActions[19].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(18); //   
		  //return 18; //      
		}
// :
		if (InputActions[21].on) { // alert("!!!!");
		  watchdog_waking_up();// 
		  run_reaction(0); // 
		  // return 0; -      
		}


// ctxId -  
for (let ctxId = 0; ctxId < BasicContextsActived.length; ctxId++) {

    if (!BasicContextsActived[ctxId]) 
		continue;
// console.log(ctxId);
    //   
    if (ctxId === 10) {
      setTextInfo("SLEEPING", "Insect in energy-saving mode (Sleep).");
      return -1;
    }

//      
    for (const { inputId, outputId } of ActionsFromContext[ctxId]) {
//		console.log(ctxId+" | "+inputId+" | "+outputId);
      if (InputActions[inputId] && InputActions[inputId].on) {//   
//		console.log(ctxId+" | "+inputId+" | "+outputId);
          run_reaction(outputId);
          return outputId;
      }
    }

//console.log(ctxId+" ");
	//////////////////////
    //   ,       fallback-

	if(ctxId === 0)// 
	{ 
		const vital=VitalsArr[0].value; //console.log(ctxId+" | "+vital);
		//   :
		if (vital >= 50 && vital < 60) {
		  run_reaction(2); //    
		  return 2;
		}  
		if (vital  >= 60 && vital < 90) {
		  run_reaction(1); //   .   
		  return 1;
		}
	}
	if(ctxId === 2)// 
	{
			run_reaction(11); // 
		  return 11;
	}
	if(ctxId === 3)// 
	{
			run_reaction(13); // 
		  return 13;
	}
	if(ctxId === 8)// 
	{
			run_reaction(19); // 
		  return 19;
	}

if(get_any_input())
setTextInfo("No actions", "No active basic context for this stimulus.");
}

return -1;
}
////////////////////////////
/*   
,       

*/
function output_action_and_info_fallback()
{
for (let ctxId = 0; ctxId < BasicContextsActived.length; ctxId++) {
    if (!BasicContextsActived[ctxId]) continue;
    if (ctxId === 10) return -1; //     

    // Fallback        
    if (ctxId === 0) {
      const v = VitalsArr[0].value;
      if (v >= 50 && v < 60) { run_reaction(2); return 2; }
      if (v >= 60 && v < 90) { run_reaction(1); return 1; }
    }
    if (ctxId === 2) { run_reaction(11); return 11; }
    if (ctxId === 3) { run_reaction(13); return 13; }
    if (ctxId === 8) { run_reaction(19); return 19; }
  }
  return -1;
}
//////////////////////////////

//   
function run_reaction(outputId)
{  
//  console.log(outputId);
const act=OutputActions[outputId]; //if(outputId==0) alert(""+outputId );
//   
		  shift_per_action(act.vital,act.shift);
		  //      
		  losses_per_action(act.losses);
		  //  
          setOutputInfo(outputId);
		//  console.log(outputId);
/*      
  :        
    .
*/
if(outputId==0)// 
{
VitalsArr[5].value = 100;// 
VitalsArr[6].value = 0;// 
//VitalsArr[6].value = Math.max(0, VitalsArr[6].value - 50);
}


/* 		  release_one_time_buttons();//       
        sep_of_puls()    */
}
/////////////////////////////////////////
/*       
shift -           

*/
function shift_per_action(vitalID,shift)
{
if (VitalsArr[vitalID].value < 100) {
    VitalsArr[vitalID].value = Math.max(0, VitalsArr[vitalID].value + shift);
  }
}
/*"   "
losses -     -  , -     
*/
function losses_per_action(losses)
{
// :    -  
  VitalsArr[0].value = Math.min(100, VitalsArr[0].value + losses);
  // :   
  VitalsArr[4].value = Math.min(100, VitalsArr[4].value + losses / 5);
}



//////////////////   
function setOutputInfo(i)
{
document.getElementById('output_actions_id').innerHTML = "<div style='font-family:arial;font-size:14pt;'><b>"+OutputActions[i].name+"</b></div><div>"+OutputActions[i].descr+"</div>";
}
function setTextInfo(text1,text2)
{
document.getElementById('output_actions_id').innerHTML = "<div style='font-family:arial;font-size:14pt;'><b>"+text1+"</b></div><div>"+text2+"</div>";

}

///////////////////////////////////////////////