/* Stimulus buttons
These buttons emulate stimuli that directly affect vitals.
Instead of simulating environment or sensory organs,
stimulation is applied directlyas if electrodes were implanted
into situation recognizers (Delgados method).
For example, "Knock breath out" reduces oxygen reserve instantly.
"Spray with water" clogs spiracles and hinders suffocation recovery.

vital  affected vital ID
on  whether stimulus is active
shift  rate of deviation from normal (positive = worsening, negative = recovery)
If name2==""  single-use button. Deactivated (release_button(id)) either instantly or after 2 pulses.
Only one button can be active at a time: stop_all_action().
{Id: NN, vital:N, on:false, shift: N, name: "xxxx", name2: "xxxx"},
*/
window.InputActions = [
//_________________________________ Air
{Id: 0, vital:0, on:false, shift: 1.0, name: "Spray with water", name2: "Stop spraying", title:"Impairs breathing"},
{Id: 1, vital:0, on:false, shift: 0.5, name: "Dust coating", name2: "Remove dust", title:"Blocks spiracles"},
{Id: 2, vital:0, on:false, shift: 60.0, name: "Knock breath out", name2: "", title:"Sudden loss of respiratory capacity"}, // one-time action
//_________________________________ Water
{Id: 3, vital:1, on:false, shift: 0.5, name: "Dehydrating wind", name2: "Stop wind", title:"Warm air blast for rapid water loss"},
{Id: 4, vital:1, on:false, shift: 60, name: "Dehydrate", name2: ""}, // severe dehydration
{Id: 5, vital:1, on:false, shift: 0, name: "Water glint", name2: "Glint gone", title:"Visual water cue recognizable by insect"},
{Id: 6, vital:1, on:false, shift: 0, name: "Provide water", name2: "Remove water", title:"Place water near insect"},
//________________________________ Food
{Id: 7, vital:4, on:false, shift: 1, name: "Physical exertion", name2: "Cancel exertion", title:"Increases food demand"},
{Id: 8, vital:4, on:false, shift: 60, name: "Exhaust", name2: "Sudden increase in hunger"}, // severe exhaustion
{Id: 9, vital:4, on:false, shift: 0, name: "Prey visible", name2: "Prey vanished", title:"Trigger approach to food"},
{Id:10, vital:4, on:false, shift: 0, name: "Provide food", name2: "Remove food", title:""},
//________________________________ Overheating
{Id:11, vital:2, on:false, shift: 60, name: "Scorch", name2: "", title:"Rapid temperature increase"},
{Id:12, vital:2, on:false, shift: 1, name: "Heat up", name2: "Stop heating", title:"Gradual temperature increase"},
//________________________________ Cold
{Id:13, vital:3, on:false, shift: 60, name: "Frostbite", name2: "", title:"Rapid temperature drop"},
{Id:14, vital:3, on:false, shift: 1, name: "Cool down", name2: "Stop cooling", title:"Gradual temperature decrease"},
//________________________________ Stress
{Id:15, vital:5, on:false, shift: 60, name: "Bright flash", name2: "", title:""},
{Id:16, vital:5, on:false, shift: 60, name: "Loud sound", name2: "", title:""},
//________________________________ Mating
{Id:17, vital:6, on:false, shift: 10, name: "Pheromone", name2: "No pheromone", title:"Triggers reproductive behavior"},
{Id:18, vital:6, on:false, shift: 0, name: "Mating partner", name2: "No partner", title:"Enables reproductive behavior"},
//________________________________ Self-preservation
{Id:19, vital:7, on:false, shift: 60, name: "Startle", name2: "", title:"Sudden dangerous cue"},
{Id:20, vital:5, on:false, shift: 10, name: "Frighten", name2: "", title:"Present threat cue"},
//________________________________ Wounds
{Id:21, vital:8, on:false, shift: 60, name: "Injure", name2: "", title:"Inflict damage"},
{Id:22, vital:8, on:false, shift: 0, name: "Disease", name2: "Recovery", title:"Infect insect"},
//________________________________ Neutral stimuli (vital:-1)
{Id:23, vital:-1, on:false, shift: 0, name: "Red flash", name2: "", title:"Neutral stimulus"},
{Id:24, vital:-1, on:false, shift: 0, name: "Bell sound", name2: "", title:"Neutral stimulus"},
{Id:25, vital:-1, on:false, shift: 0, name: "Lemon scent", name2: "", title:"Neutral stimulus"},
{Id:26, vital:5, on:false, shift: -10, name: "Pleasant breeze", name2: "", title:"Calming effect"},
// During sleep, energy consumption decreases: food vital baseline is 0.005, sleep improves it by 0.004
{Id:1000, vital:4, on:false, shift: -0.004, outID:1000, name: "Circadian sleep", name2: "Awaken", title:"Sleep/wake cycle"},
];

////////////  
function init_input_actions()
{
var acts="";
for( var i = 0; i < InputActions.length; i++) 
{
var brd="";
if(InputActions[i].name2.length==0)
	brd=" style='border:solid 1px red;' ";
if(InputActions[i].vital==-1)
	brd=" style='border:solid 1px blue;' ";
acts += `
	<div id="input_action-item_${i}" class="input_action-item" ${brd} onclick="onInput_actionClick(${i})" title="${InputActions[i].title}">
        ${InputActions[i].name}
    </div>
`;
}
	
document.getElementById('input_actions_id').innerHTML = acts;
}
////////////////////////////////////////




////////////////////////////////////////
/*   

*/
function onInput_actionClick(i)
{
//	alert(i+" | "+InputActions[i].shift);
var btn=document.getElementById('input_action-item_'+i); 
if(InputActions[i].on)//  
{  //alert("!!!!  "+i);
btn.style.backgroundColor="#eeeeee";
btn.innerHTML=InputActions[i].name;
InputActions[i].on=false;

//   ,    
if (InputActionsCur.impID === i) {
  InputActionsCur = { impID: -1, context: "", actionID: -1 };
}

if(InputActions[i].Id==1000)// 
{
IsSpeeping=false;
BasicContextsActived[10] = false;
setTextInfo("","");
}

}
else//   
{
IsActualStimul=true;
//    
/*InputActionsPrev.impID=InputActionsCur.impID;
InputActionsPrev.context=InputActionsCur.context;
InputActionsPrev.actionID=InputActionsCur.actionID;*/
//      "" ()
//        actionID = -1
if (InputActionsCur.impID >= 0) {
  InputActionsPrev.impID = InputActionsCur.impID;
  InputActionsPrev.context = InputActionsCur.context;
  InputActionsPrev.actionID = -1; // 
} else {
  InputActionsPrev.impID = -1;
  InputActionsPrev.context = "";
  InputActionsPrev.actionID = -1;
}
InputActionsCur.impID=InputActions[i].Id;
InputActionsCur.context=get_cur_context();

stop_all_action(); //   
btn.style.backgroundColor="#E1E4FF";
if(InputActions[i].name2.length==0)
	btn.innerHTML="  ";
else
	btn.innerHTML=InputActions[i].name2;
InputActions[i].on=true;
if(InputActions[i].Id==1000)// 
{ //alert(IsSpeeping);
IsSpeeping=true;
BasicContextsActived[10] = true;
setTextInfo(""," ,     .");
}
}

}
//////////////////////////////////////////

function get_sleep_id()
{
for( var i = 0; i < InputActions.length; i++)
	{
if(InputActions[i].Id == 1000)
	return i;
	}

}
///////////////////////////////////////


///////////////////////////////////////////
/*      
  
*/
function release_button(id)
{
InputActions[id].on=false;
var btn=document.getElementById('input_action-item_'+id);  
btn.style.backgroundColor="#eeeeee";
btn.innerHTML=InputActions[id].name;
//addVitalsShift(btn.vital,-btn.shift);
}
///////////////////////////////////////////
//        
function release_one_time_buttons()
{
for( var i = 0; i < InputActions.length; i++)
{
	if(InputActions[i].on && InputActions[i].name2.length==0)
	{
		release_button(i);
	}
}
}
///////////////////////////////////////////////

/*     .      .
*/
function stop_all_action()
{
for( var i = 0; i < InputActions.length; i++)
{
if(InputActions[i].on)
	{
		release_button(i);
	}
}
}

//   -  
function get_any_input()
{
for( var i = 0; i < InputActions.length; i++)
{
if(InputActions[i].on)
	{
		return true;
	}
}
}