/* Conditional reflex
Requirements for formation:
1. Temporal coincidence of neutral stimulus (CS) with unconditioned stimulus (US).
2. CS must slightly precede US.
3. CS must not elicit strong innate response.
4. Reflex forms only after several pairings (e.g., >2 in news_detector.go).
Reflex fades if pairings aren't reinforced over time (e.g., overnight).

Extinction conditions:
1. Long absence of CS > tracked via lastActivation timestamp.
2. Competitive stimuli override weaker reflexes.
3. Unlike operant conditioning, no post-action reinforcement needed  innate reflexes are stable; conditional ones serve same function with new stimuli.
4. Newer reflexes extinguish faster than older, stronger ones.

Conditional reflex may build upon unconditioned reflex, reusing its action for new CS.
*/
// Conditional reflex structure
window.CReflex = {
  ID: -1,
  context: "",          // Active context ID combination (proto-emotion)
  inputID: -1,          // InputActions ID  neutral stimulus
  actionID: -1,         // OutputActions ID  linked response
  birthTime: -1,        // Pulse when created
  lastActivation: -1,   // Last activation pulse
  tryCount: 0           // Pairing attempts; becomes active at tryCount > 3
};

//   
window.NextReflexId = 0;
window.ConditionalReflexes = [];
//   : window.ConditionalReflexes.push(newReflex);

//   ,       .
window.InputActionsPrev={ impID: -1, context: "", actionID: -1 };
//     ,     InputActionsPrevID
window.InputActionsCur={ impID: -1, context: "", actionID: -1 };

//    
function condition_reflex_forming()
{
	if(InputActionsPrev.actionID>=0)//     
		return;
	if(InputActionsCur.actionID<0)//      
		return;		
	if(InputActionsPrev.impID<0)
		return;

	//  :     !
  const prevInput = InputActions.find(a => a.Id === InputActionsPrev.impID);
  if (!prevInput || prevInput.vital !== -1) {
    return; //       
  }

// alert("!!!!!!!!!");
//    
const idx = findConditionalReflexIndex(InputActionsCur.context, InputActionsPrev.impID, InputActionsCur.actionID);
if (idx === -1) {

  //    ,  
  NextReflexId++;
ConditionalReflexes.push({
    ID: NextReflexId,
    context: InputActionsCur.context,
    inputID: InputActionsPrev.impID,
    actionID: InputActionsCur.actionID,
    birthTime: Cur_puls_val,
    lastActivation: Cur_puls_val,
    tryCount: 0
  });
    var out = OutputActions[InputActionsCur.actionID].name + "<br>" + OutputActions[InputActionsCur.actionID].descr;
    setTextInfo("Conditional reflex prototype created", out);
//console.log(ConditionalReflexes);
} else {
  //       tryCount
  ConditionalReflexes[idx].tryCount++;
  ConditionalReflexes[idx].lastActivation = Cur_puls_val;
      var out = OutputActions[InputActionsCur.actionID].name + "<br>" + OutputActions[InputActionsCur.actionID].descr;
    setTextInfo("Conditional reflex prototype reinforced (" + ConditionalReflexes[idx].tryCount + ")", out);
}

}
///////////////////////////////////////////

/* ,   ConditionalReflexes    
   context, inputID  actionID, 
  ,     ID   ConditionalReflexes
  -1
*/
function findConditionalReflexIndex(context, inputID, actionID)
{
  for (let i = 0; i < ConditionalReflexes.length; i++) {
    const cr = ConditionalReflexes[i];
    if (
      cr.context === context &&
      cr.inputID === inputID &&
      cr.actionID === actionID
    ) {
//		console.log(context+", "+cr.context+" && "+inputID+", "+cr.inputID+" && "+actionID+", "+cr.actionID);
      return i; //    
    }
  }
//  console.log(ConditionalReflexes);
  return -1; //  
}
////////////////////////////////////////////



/*        inputID    get_cur_context()
 ,   .   sep_of_puls()  output_action_and_info().
   -  true,  - false
*/
function check_and_run_CReflex(inputID)
{
//	if(ConditionalReflexes.length) console.log(": "+ConditionalReflexes.length);
if(inputID<0)
	return false;

	const currentContext = get_cur_context(); // "0,2"  "none"  ..

//     
  for (let i = 0; i < ConditionalReflexes.length; i++) {
    const cr = ConditionalReflexes[i];
    
//console.log(cr.inputID +" == "+ inputID+" | "+cr.context +" == "+ currentContext+" | "+cr.tryCount);
    // :   ,    ""
    if (
      cr.inputID === inputID &&
      cr.context === currentContext &&
      cr.tryCount > 3 //    3+ 
    ) { 
// console.log(ConditionalReflexes);
      //   
      //run_reaction(cr.actionID);
      var out = OutputActions[cr.actionID].name + "<br>" + OutputActions[cr.actionID].descr;
      setTextInfo("Conditional reflex triggered:", out);
      
	  cr.tryCount++;//  ,    -    
      //    
      cr.lastActivation = Cur_puls_val;
      
      return true; //  
    }
  }
  
  return false; //     
}
///////////////////////////////////////////////
