/* Basic contexts
! Context names and purposes are defined by the function of parameter restoration, i.e.
- Suffocation > Ventilation context
- Heat > Cooling context

autonomic  context that changes activity outside of getActiveBasicContexts(), e.g., Circadian rhythm
*/
window.BasicContexts = [
  {id:0,  importance:90, autonomic:false, name:"Ventilation" },           // Airway clearance / tracheal ventilation
      // Response to Id:0 (Suffocation). Active tracheal ventilation,
      // cleaning spiracles with limbs, moving out of poor gas environment
  {id:1,  importance:80, autonomic:false, name:"Drinking" },              // Water intake
      // Response to Id:1 (Dehydration). Seeking and consuming water:
      // drinking droplets, absorbing moisture through cuticle, consuming plant juices
  {id:2,  importance:70, autonomic:false, name:"Cooling" },                // Thermoregulation: cooling
      // Response to Id:2 (Overheating). Seeking shade, burrowing into substrate,
      // nocturnal activity, evaporative cooling (in some species)
  {id:3,  importance:70, autonomic:false, name:"Warming" },                // Thermoregulation: warming
      // Response to Id:3 (Hypothermia). Basking in sun,
      // muscle thermogenesis (wing vibration), selecting warmed areas
  {id:4,  importance:60, autonomic:false, name:"Feeding" },                // Foraging
      // Response to Id:4 (Hunger). Foraging and feeding:
      // consuming nectar, chitinous objects, plant sap
  {id:5,  importance:30, autonomic:false, name:"Freezing" },               // Thanatosis (playing dead)
      // Response to Id:5 (Stress). Complete immobility in response
      // to short-term threat: shadow, substrate vibration
  {id:6,  importance:20, autonomic:false, name:"Mating" },                 // Reproductive behavior
      // Response to Id:6 (Mating urge). Partner search, courtship displays,
      // mating, egg-laying
  {id:7,  importance:50, autonomic:false, name:"Avoidance" },              // Threat avoidance
      // Response to Id:7 (Self-preservation). Active escape, retreat to shelter,
      // adoption of defensive postures
  {id:8,  importance:100, autonomic:false, name:"Healing" },               // Immobilization and wound licking
      // Response to Id:8 (Injuries). Minimizing movement to reduce hemolymph loss,
      // cleaning wounds with mouthparts
  {id:9,  importance:10, autonomic:false, name:"Rest" },                   // Minimally active exploratory/maintenance mode
      // Grooming  cleaning antennae, legs, wings
      // Not foraging, but monitoring environment for new resources, mates, or threats
  {id:10, importance:30, autonomic:true, name:"Sleep" }                    // Activity/rest cycle (Circadian rhythm)
      // This mode is not triggered by vitals, but by external day/night cycles.
      // It globally suppresses non-critical behaviors and enforces energy-saving mode,
      // analogous to the "Sleep" mode in the base example.
];

//       true  false:
window.BasicContextsActived = Array(BasicContexts.length).fill(false); 